﻿/**
 *	@file	dmd_usj.d
 *	@brieaf UTF8,UTF16で書かれたdソースの" ' ` 文字列を
 *			os依存のMB(SJIS)文字コードに変換(必要に応じて\対処).
 *			dmd & win環境依存
 *	@author tenk@6809.net
 *	@date	2004-01-25
 *	@note
 *			cc1_sj を元に作成.(dmd_sj). がUnicode対応で大幅に...
 */

private:

import std.stream;
import std.string;
import std.file;
import std.process;
//import std.utf;
import utf_ex;
import std.ctype;
import std.c.stdio;
import std.c.stdlib;
import std.c.time;
import std.c.windows.windows;

version = TCHAR_IS_CHAR;
import mbc;
import mbtextfile;

import dbg;


/** -usj 時のヘルプ */
void usage()
{
	mbprintf(
	   "usage> dmd_usj.exe -usj:\n"
	   "  -usj:no         dmd_usjの追加機能を使わず、そのままdmdコンパイラを起動\n"
	   "  -usj:MBC        ソースがMBC(SJIS)かUTF8の見分けが付かない場合MBC として扱う\n"
	   "  -usj:UTF8       ソースがMBC(SJIS)かUTF8の見分けが付かない場合UTF8として扱う\n"
	   "  -usj:mbs        入力ソース中 \" ' ` で囲まれた範囲をMBC(SJIS)文字列に変換\n"
	   "  -usj:fl[FILE]   import dbg; の代わりに import FILE; にする\n"
	   "  -usj:ver=[NAME] コンパイラとして dmd_NAME.exe を使う\n"
	);
}


//extern(C) int spawnve(int,char *,char **,char **);


public int main(char[][] args)
{
	// コンフィグファイル、環境変数を参照、@resfileを展開
	exArgs(args, ".cfg", "DMD_USJ", "@");

	char[] verName = "";

	// オプション -usj: が指定されているか調べる.
	Conv conv = new Conv;
	bit  usjMode = 1;
	int  fileNum = 0;
	int  n = 1;
	for (int i = n; i < args.length; i++) {
		char[] p = mbsToUTF8(cast(ubyte[])args[i]);		// MS全角->UTF8
		debug mbprintf("%.*s\n", p);
		if (p == "-usj") {
			usage();
			return 1;
		} else if (equLong(p, "-usj:")) {
			if (p == "-usj:mbs") {
				conv.mbsStrMode_ = 1;
			} else if (p == "-usj:no") {
				usjMode = 0;
			} else if (p == "-usj:MBC") {
				conv.fileCT_ = MbcType.MBC;
			} else if (p == "-usj:UTF8") {
				conv.fileCT_ = MbcType.UTF8;
			//} else if (p == "-usj:NONE") {
				//conv.fileCT_ = MbcType.NONE;
			} else if (equLong(p, "-usj:fl")) {
				conv.flname_ = toUTF32( p[7 .. p.length] );
				if (conv.flname_.length == 0)
					conv.flname_ = "dbg";
				//mbprintf("%.*s\n", toUTF8(conv.flname_) );
			} else if (equLong(p, "-usj:ver=")) {
				verName = "_" ~ p[9 .. p.length];
			} else if (p == "-usj:_debug") {
				conv.dbgMode_	 = 1;
			} else {
				mbprintf("bad -usj: option(%.*s)\n", p);
				return 1;
			}
		} else {
			if (p[0] != '-')
				fileNum++;
			args[n] = p;
			n++;
		}
	}
	args.length = n;

	// 本物の dmd.exe のパス/ファイル名を取得.
	char[] exeName = args[0];
	if (find(exeName, "_usj.exe") > 0) {
		// ラッパーがdmd_usj.exeなら本物はdmd.exe
		verName = verName ~ ".exe";		// ついでにバージョン違いdmdの呼出を可能に.
		exeName = replace(exeName, "_usj.exe", verName);
	} else {
		// ラッパーがdmd.exe なら本物はdmd_org.exe
		if (verName.length == 0)
			verName = "_org";
		verName = verName ~ ".exe";		// ついでにバージョン違いdmdの呼出を可能に.
		exeName = replace(exeName, ".exe", verName);
	}

	// コンパイラ名を設定
	debug mbprintf("exeName=%.*s\n", exeName);
	args[0] = exeName;

	// -usj:no 時は、何も変換せず、dmdに渡す
	if (usjMode == 0 || fileNum == 0) {
		return execArgs(args);
	}
	return conv.exec(args);
}



/** args[][]に、コンフィグファイル、環境変数、の順に内容をargsの
 * 先頭に付けたした後、@で始まる引数があればレスポンスファイルと
 * してその位置に引数に展開する。
 */
void exArgs(inout char[][] args, char[] cfgExt, char[] envName, char[] resTop)
{
	// 環境変数を取得 (※後で挿入するcfgにargsがずらされるので、先に環境変数を展開)
	if (envName.length > 0) {
		//char[] env = toString(getenv(envName));
		char[] env = mbsToUTF8(getenv(envName));
		if (env.length > 0) {
			debug mbprintf("env=%.*s\n", env);
			char[][] tmp = args[1 .. args.length];
			args.length = 1;
			args = args ~ split(env) ~ tmp;
		}
	}

	// コンフィグファイルを読み込む. 拡張子名が . を合わせ2文字以上あること
	if (cfgExt.length >= 2) {
		char[] cfgName = args[0].dup;
		cfgName[cfgName.length-cfgExt.length .. cfgName.length] = cfgExt;
		debug mbprintf("cfgName=%.*s\n", cfgName);
		char[] cfg;
		try {
			cfg = cast(char[])std.file.read(cfgName);
		} catch (FileException) {
		}
		char[][] cfgArgs = split(cfg);
		if (cfgArgs.length > 0) {
			//debug mbprintf("cfg=%.*s\n", cfg);
			char[][] tmp = args[1 .. args.length];
			args.length = 1;
			args = args ~ cfgArgs ~ tmp;
		}
	}

	// args[]を舐めて、レスポンスファイルを展開
	if (resTop.length > 0) {
		for (int i = 1; i < args.length; i++) {
			char[] p = args[i];
			if (equLong(p, resTop)) {
				debug mbprintf("resfile %.*s\n", p);
				char[] resName = p[resTop.length .. p.length];
				char[] res = cast(char[])std.file.read(resName);
				char[][] resArgs = split(res);
				char[][] tmp;
				if (i+1 < args.length) {
					tmp = args[i+1 .. args.length];
				}
				args.length = i;
				args = args ~ resArgs;
				i = args.length;
				args  ~= tmp;
			}
		}
		debug {
			for (int j = 0; j < args.length; j++)
				mbprintf("\t%.*s\n", args[j]);
		}
	}
}



/** args をつなげてコマンドラインにして実行 */
int execArgs(char[][] args)
{
	char[] cmd;
	foreach(char[] p; args)
		cmd = cmd ~ p ~ " ";
	debug mbprintf("%.*s\n", cmd);

	version (Win32) {
		// win9x で、コマンドラインが 1024以上になるなら、レスポンスファイルに変換
		if (cmd.length > 1023 && isWinNT() == 0) {
			char[] tmp = toString(tmpnam(""));
			debug mbprintf("[tmp]%.*s\n", tmp);
			cmd = "";
			for (int i = 1; i < args.length; i++)
				cmd = cmd ~ args[i] ~ "\n";
			std.file.write(tmp, cmd);
			cmd = args[0] ~ " @" ~ tmp;
			debug mbprintf("cmdline=%.*s\n", cmd);
			int n = std.process.system(cmd);
			try {
				std.file.remove(tmp);
			} catch (FileException) {
			}
			return n;
		}
	}
	return std.process.system( cmd );
}



/// 変換の本体
class Conv {
	bit mbsStrMode_ = 0;				///< "`'文字列中を MBS に変換するなら1に.
	bit dbgMode_	= 0;				///< dmd_usj自体のデバッグ用
	MbcType fileCT_ = MbcType.UTF8; 	///< 入力ソースの文字コード種類
	dchar[] flname_ = "dbg";			///< __FL__置換をonにするimport dbg;の"dbg"を変える文字列

	/** オプション以外のファイルがあればMB文字への変換してから dmd.exe を実行 */
	int exec(char[][] args)
	{
		bit 	 compileOnly = 0;
		char[]	 oname = "";
		char[]	 firstName = "";
		char[]	 tgtName = "";
		char[][] baseList;
		char[][] tmpList;
		for (int i = 1; i < args.length; i++) {
			char[] p = args[i];
			//debug mbprintf("%d %s\n", i, (char*)p);
			if (p == "-c") {
				compileOnly = 1;
			} else if (equLong(p, "-of")) {
				oname = p[3..p.length];
				if (oname.length > 4 && icmp(oname[oname.length - 4 .. oname.length], ".exe") == 0) {
					tgtName = oname;
				}
			} else if (p.length > 4 && icmp(p[p.length-4 .. p.length], ".exe") == 0) {
				tgtName = p;
			} else if (p[0] != '-') {
				int pos = rfind(p, '.');
				if (pos > 0 && p[pos..p.length] == ".d")
				{
					char[] baseName = p[0..pos];
					if (firstName.length == 0)
						firstName = baseName;
					char[] tmpName	=  baseName ~ "__DtMP__";
					if (0) {	// あんまり無意味なんで、やっぱやめ
						time_t tim;
						time(&tim); 	// 暫定...
						tmpName  ~=  toHex(cast(uint)tim);
					}
					char[] dtmpName = tmpName ~ ".d\0";
					dtmpName.length = dtmpName.length - 1;	// 無作法なやり方だとは思うが、お試し。
					debug mbprintf("tmpname=%.*s\n", dtmpName);

					// 実際の変換
					bit cnvFlg = convUtfStrToMbStr(p, dtmpName);
					if (cnvFlg) {
						args[i]  =	dtmpName;
						baseList ~= baseName;
						tmpList  ~= tmpName;
					} else {
						// 作成したけど、元ソースのコンパイルで問題ないので、この場で破棄
						std.file.remove(dtmpName);
					}
				}
			}
		}

		// コンパイルのみ、でないのに出力exe名の指定がない場合は、
		// 最初のソースファイル名を元に出力ファイル名を設定
		if (compileOnly == 0 && oname.length == 0 && firstName.length > 0) {
			tgtName = firstName ~ ".exe";
			oname = "-of" ~ tgtName;
			args ~= oname;
		}
		debug mbprintf("tgtName=%.*s\n", tgtName);

		// 本物の dmd.exe を実行
		int rc = execArgs(args);

		// 生成したテンポラリdファイルを削除, 旧objファイル削除&新objの変名
		for (int n = 0; n < baseList.length; n++) {
			char[] dtmp = tmpList[n] ~ ".d";
			debug mbprintf("remove %.*s\n", dtmp);
			if (dbgMode_ == 0) {
				try {
					std.file.remove(dtmp);
				} catch (FileException) {
					// (少々の)エラーは無視していいことに^^;
				}
			}
			char[] obj	= baseList[n] ~ ".obj";
			char[] otmp = tmpList[n]  ~ ".obj";
			debug mbprintf("rename %.*s to %.*s\n", otmp, obj);
			forceRename(otmp, obj);
		}

		// w32s -> w95 化
		if (/*rc == 0 &&*/ tgtName.length > 0)
			w32s_to_w95(tgtName);
		return rc;
	}

private:
	int srcLine_;
	char[] srcName_;

	/** SJIS/UTF16/UTF32ならUTF8に変換.
	 *	UNICODEで書かれた dソースから、"文字列" `文字列` '文字' の文字コードを
	 *	マルチバイト文字(シフトJIS)に変換する(必要に応じて\を挿入...
	 *  だったが、dmdのUTF8チェックが厳しくなったので\x??に変換)
	 */
	bit convUtfStrToMbStr(char[] srcName, char[] tmpName)
	{
		debug mbprintf("%s -> %s\n", cast(char*)srcName, cast(char*)tmpName);
		// 読み込みファイル open
		srcName_ = srcName;
		fnameSepToSL(srcName);
		MbTextFile srcf = new MbTextFile(srcName, FileMode.In, fileCT_);
		debug mbprintf("MbcType %d->%d\n", srcf.fileMbcType(), fileCT_);

		// 出力するテンポラリファイルの作成
		MbTextFile tmpf = new MbTextFile;
		tmpf.create(tmpName, FileMode.Out);

		// おまじないの一行を出力
		tmpf.printf("#line 1 \"%s\"\n", cast(char*)srcName);

		bit cnvFlg	 = (srcf.fileMbcType == MbcType.MBC);
		bit flMode	 = 0;		// impport dbg; があれば、__FILE__,__LINE__,__FL__を使えるようにする
		int mode	 = 0;		// " ' ` // /**/ /++/ の範囲か
		int nestedCmt= 0;
		srcLine_ = 0;
		while (srcf.eof() == 0) {
			++srcLine_;
			//debug mbprintf("[%d]\n", srcLine_);

			// 1バイト出力ルーチンを定義
			void putCh(char ch) {
				tmpf.write(cast(char)ch);
			}

			// 一行入力
			dchar[] buf = srcf.readLineD();

			//if (0/*mode == 0*/) {	// __FL__ __FILE__ __LINE__ があれば、置換
			//	int pos = 0;
			//	if (replace_fl(buf, pos) > 0)
			//		cnvFlg = 1; 			// 置換が発生した
			//}

			// 空の文字列だと ArrayBoundsError の対処が面倒なんでEOLとして\0を付加
			buf ~= '\0';
			dchar b = 0;
			dchar d = 0;
			for (int n = 0; n < buf.length-1; b = d) {
				d = buf[n++];
				//debug mbprintf("%4x:", d);
				dchar k = buf[n];
				if (d < 0x80) {
					if (d == '\0') {
						break;
					} else if (d == '"') {
						if (mode == 0)
							mode = '"';
						else if (mode == '"')
							mode = 0;
						else if (mode == '"'+0x100)
							mode = 0;
						else if (mode == '`' && mbsStrMode_)	// `を"に置換してる都合\"にエスケープする必要がある
							putCh('\\');
					} else if (d == 'r' && k == '"' && mode == 0) {
						mode = '"'+0x100;
						if (mbsStrMode_ == 0)	// 通常なら r を出す
							putCh(d);
						d = buf[n++];
					} else if (d == '\'') {
						if (mode == 0)
							mode = '\'';
						else if (mode == '\'')
							mode = 0;
					} else if (d == '`') {
						if (mode == 0) {
							mode = '`';
							if (mbsStrMode_)
								d = '"';  // MBC埋め込み対策で、`は"に置換
						} else if (mode == '`') {
							mode = 0;
							if (mbsStrMode_)
								d = '"';  // MBC埋め込み対策で、`は"に置換
						}
					} else if (mode == '*' && d == '*') {
						if (k == '/') {
							putCh(d);
							d = buf[n++];
							mode = 0;
						}
					} else if (mode == '+' && d == '+') {
						if (k == '/') {
							putCh(d);
							d = buf[n++];
							nestedCmt--;
							if (nestedCmt <= 0) {
								mode = 0;
								nestedCmt = 0;
							}
						}
					} else if (k == '+' && d == '/' && (mode == 0 || mode == '+')) {
						putCh(d);
						d = buf[n++];
						mode = '+';
						nestedCmt++;
					} else if (mode == 0 && d == '/') {
						if (k == '*') {
							putCh(d);
							d = buf[n++];
							mode = '*';
						} else if (k == '/') {
							putCh(d);
							d = buf[n++];
							mode = '/';
						}
					} else if (flMode && mode == 0 && d == '_' && k == '_' && isSymF(b) == 0) {
						// __FL__ __FILE__ __LINE__ があれば、置換
						int nn = n - 1;
						if (replace_fl(buf, nn) >= 0) {
							cnvFlg = 1;
							n--;
							b = 0;
							continue;
						}
					} else if (mode == 0 && d == 'i' && k == 'm' && isSymF(b) == 0 && isStr_import_dbg(buf, n-1)) {
						// import dbg; があった場合
						flMode = 1;
					} else if (d == '\\') {
						if (mode == '`' || mode == '"'+0x100) {
							if (mbsStrMode_)
								putCh('\\');
						} else if (k) {
							putCh(d);
							d = buf[n++];
						}
					}
					putCh(d);

				} else {
					// 文字定数、文字列定数中に全角があるなら
					if ((mode == '\'' || mode == '"' || mode == '`' || mode == '"'+0x100) && mbsStrMode_) {
						cnvFlg = 1;
						dchar[1] tmp;
						tmp[0]  = d;
						ubyte[] mb = toMBS( tmp );
						for (int j = 0; j <  mb.length; j++) {
							if (1) {
								tmpf.printf("\\x%02x", cast(uint)mb[j]);
							} else {	// char型はutf8を満たさないとエラーになるので廃止
								tmpf.printf("%c", mb[j]);
								if (mb[j] == '\\')
									tmpf.printf("\\");
							}
						}
					//} else if (mode == '"'+0x100 && mbsStrMode_) {	// r"の場合
					//	cnvFlg = 1;
					//	dchar[1] tmp;
					//	tmp[0] = d;
					//	ubyte[] mb = toMBS( tmp );
					//	tmpf.printf("%.*s", mb);
					} else {
						char[] buf4;
						std.utf.encode(buf4, d);
						tmpf.writeBlock(&buf4[0], buf4.length);
						//tmpf.puts(buf4);		// 標準出力されちまう...てputsなんて本来メンバにないやん^^;
					}
				}
			}
			putCh('\n');
			if (mode == '/')
				mode = 0;
		}
		srcf.close();
		tmpf.close();
		return cnvFlg;
	}

	/** シンボルを構成する文字か否か */
	bit isSymF(dchar d) {
		return d >= 0x80 || isalnum(d) || d == '_';
	}

	/** buf中に __FILE__,__LINE__,__FL__ があれば、置き換える */
	int replace_fl(inout dchar[] buf, inout int pos)
	{
		static dchar[][] words = ["__FL__", "__FILE__", "__LINE__"];
		int num = 0;
		while (pos < buf.length) {
			int n = findWords(buf, pos, words);
			if (n < 0)
				break;
			dchar[] tmp = buf[pos+words[n].length .. buf.length].dup;
			buf.length = pos;
			//debug mbprintf(toUTF8(buf));
			//debug mbprintf(toUTF8(tmp));
			dchar[] wd;
			if (n == 1) {
				wd = toUTF32(`"` ~ srcName_ ~ `"`);
			} else if (n == 2) {
				wd = toUTF32(format("%d", srcLine_));
			} else {
				wd = toUTF32(`"` ~ srcName_ ~ format(" (%d) ", srcLine_) ~ `"`);
			}
			buf ~= wd;
			pos = buf.length;
			buf ~= tmp;
			num++;
			//debug mbprintf(toUTF8(buf));
		}
		return num;
	}

	/** ソース行中に import dbg; があるか否か */
	bit isStr_import_dbg(dchar[] line, int pos)
	{
		if (equLong(line[pos ..line.length], "import")) {
			pos = skipSpc(line, pos+6);
			if (equLong(line[pos .. line.length], flname_)) {
				pos = skipSpc(line, pos + flname_.length);
				if (line[pos] == ';') {
					//mbprintf("ok\n");
					return 1;
				}
			}
		}
		return 0;
	}

	/** ファイル名中のディレクトリセパレータの\を/にする */
	void fnameSepToSL(inout char[] src)
	{
		for (int i = 0; i < src.length; i++) {
			char c = src[i];
			// とりあえず、ファイル名はUTFでなくMBSと仮定しておく
			if (ismbblead(c) && i+1 <src.length)
				i++;
			else if (src[i] == '\\')
				src[i] = '/';
		}
	}

	/** サイズ可変でないウィンドウの縁が立体化しないバグ対策。
	 *	NYSLライセンスのws2w95. v1.00( http://www1.kcn.ne.jp/~robe/d/ws2w95.html )
	 *	のルーチンをコピペ改造
	 */
	void w32s_to_w95(char[] tgtName)
	{
		File file = new File;
		try {
			file.open(tgtName, FileMode.Out);
		} catch (StreamError) {
			// ファイルが無かったとみなして帰る
			return;
		}
		debug mbprintf("w32_to_w95\n");
		file.seekSet(0xA0);
		file.write(cast(ubyte) 0x04);
		file.seekSet(0xA8);
		file.write(cast(ubyte) 0x04);
		file.write(cast(ubyte) 0x00);
		file.write(cast(ubyte) 0x00);
		file.close();
	}
}



// --------------------------------------------------------------------------
//

/** ファイル oldname を newname に変名する。newnameが存在すれば予め削除。 */
void forceRename(char[] oldname, char[] newname)
{
	try {
		// 古いnewnameファイルを削除
		std.file.remove(newname);
	} catch (FileException) {
		// ファイルがない場合対策。(少々の)エラーは無視していいことに^^;
	}
	try {
		std.file.rename(oldname, newname);
	} catch (FileException) {
		// エラーにしたほうがいいんだが、手抜きで、無視
	}
}



/** 文字列 buf のposからの中に words[]の何れかの単語があれば、posを更新し、その番号を返す.
 *	なければ -1 を返す。
 *	なお単語は A-Za-z_ と 0x80以上の文字の構成とし、それ以外のもので区切られている。
 */
int findWords(dchar[] buf, inout int pos, dchar[][] words)
{
	dchar b = 0;
	int po = pos;
	while (po < buf.length) {
		bit isSymF(dchar d) {
			return d >= 0x80 || isalnum(d) || d == '_';
		}
		dchar c = buf[po];
		if (isSymF(b) == 0 && isSymF(c)) {
			for (int i = 0; i < words.length; i++) {
				dchar[] wd = words[i];
				int wdlen  = wd.length;
				int bl = buf.length - po;
				if (bl >= wdlen
					&& c == wd[0]
					&& memcmp(&buf[po], &wd[0], wdlen * dchar.sizeof) == 0
					&& (bl == wdlen || isSymF(buf[po+wdlen]) == 0)
				){
					pos = po;
					return i;
				}
			}
		}
		b = c;
		po++;
	}
	return -1;
}


/** 空白をスキップ */
int skipSpc(dchar[] buf, int pos)
{
	while (pos < buf.length) {
		dchar c = buf[pos++];
		if (c > 0x20 && c != 0x7f)
			return pos - 1;
	}
	return pos;
}


/** s1 が s2 と同じか、長い場合に true を返す */
bit equLong(char[] s1, char[] s2)
{
	return ncmp(s1, s2, s2.length) == 0;
}


/** s1 が s2 と同じか、長い場合に true を返す */
bit equLong(dchar[] s1, dchar[] s2)
{
	return ncmp(s1, s2, s2.length) == 0;
}


/** 文字列の先頭 n byte を比較 */
int ncmp(char[] s1, char[] s2, uint/*size_t*/ l)
{
	// dmd v0.79現在 std.c.time をimport して size_t を使うと、
	// size_tが定義の衝突エラーになる(T T)
	uint/*size_t*/ l1 = (s1.length < l) ? s1.length : l;
	uint/*size_t*/ l2 = (s2.length < l) ? s2.length : l;
	return std.string.cmp(s1[0..l1], s2[0..l2]);
}


/** 文字列の先頭 n byte を比較 */
int ncmp(dchar[] s1, dchar[] s2, uint len)
{
	for (int i = 0; i < len; i++) {
		if (i < s1.length) {
			dchar c1 = s1[i];
			if (i < s2.length) {
				dchar c2 = s2[i];
				int f = (c1 > c2) - (c1 < c2);
				if (f != 0)
					return f;
			} else {
				return 1;
			}
		} else {
			return -(i < s2.length);
		}
	}
	return 0;
}



/** 16進数文字列に変換 */
char[] toHex(uint val)
{
	char[10] t;
	sprintf(t, "%X", val);
	return toString(t).dup;
}


/** 16進数文字列に変換. n:桁数 */
char[] toHex(uint val, int n)
{
	if (n > 8) {
		char[] t;
		t.length = n + 1;
		sprintf(t, "%0*X", n, val);
		return toString(t);
	} else {
		char[8] u;
		u[0] = std.string.hexdigits[val >> 28];
		u[1] = std.string.hexdigits[(val >> 24) & 15];
		u[2] = std.string.hexdigits[(val >> 20) & 15];
		u[3] = std.string.hexdigits[(val >> 16) & 15];
		u[4] = std.string.hexdigits[(val >> 12) & 15];
		u[5] = std.string.hexdigits[(val >>  8) & 15];
		u[6] = std.string.hexdigits[(val >>  4) & 15];
		u[7] = std.string.hexdigits[val 		& 15];
		return u[8-n .. 8].dup;
	}
}


// -----------------------------------------

version (Win32) {
	struct OSVERSIONINFOA {
		DWORD dwOSVersionInfoSize;
		DWORD dwMajorVersion;
		DWORD dwMinorVersion;
		DWORD dwBuildNumber;
		DWORD dwPlatformId;
		CHAR  szCSDVersion[ 128 ];
	}
	extern(Windows) export BOOL GetVersionExA(OSVERSIONINFOA* lpVersionInformation);

	/** WinNT以降か否か */
	bit  isWinNT()
	{
		OSVERSIONINFOA osvi;
		memset(&osvi, 0, OSVERSIONINFOA.sizeof);
		osvi.dwOSVersionInfoSize = OSVERSIONINFOA.sizeof;
		bit rc = cast(bit)GetVersionExA(&osvi);
		if (rc != 0)
			rc = osvi.dwPlatformId >= 2/*VER_PLATFORM_WIN32_NT*/;
		return rc;
	}
}
