/**
 *  @file PngDecoder.hpp
 *  @brief  png摜f[^WJ.
 *  @author Masashi KITAMURA
 *  @note
 *
 *      - g
 *          - setData(binData,size) Ń[pngf[^ݒ肵A
 *            ̌ read()malloc24rbgF摜𓾂.
 *          - 邢setData(), TCYwidthByte()*height() ȏ̃
 *            Ăьŗpӂread(pix, ...)g.
 */
#ifndef PNGDECODER_HPP
#define PNGDECODER_HPP

#include <stddef.h>
#include <assert.h>

#include "libpng/png.h"


/// png摜f[^WJ. (libjpeg.lib̃bp[)
class PngDecoder {
public:
    PngDecoder();
    ~PngDecoder();
    PngDecoder(const void* binData, unsigned binDataSize);

    static bool isSupported(const void* data);

    /// ŊmۂĂ郁J.
    void        release();

    /// pngf[^ݒ. |C^ێ邾Ȃ̂read()IObinDataj󂵂Ȃ.
    bool        setData(const void* binData, unsigned binDataSize);

    unsigned    bpp()        const { return bpp_; }         ///< rbg/sNZ. 24̂.
    unsigned    width()      const { return width_; }       ///< .
    unsigned    height()     const { return height_; }      ///< c.
    unsigned    widthByte(unsigned algn=0) const;           ///< algnoCgɃACgς̉oCg.

    void        setBigEndian() { bigEndian_  = true; }
    void        revY()         { revY_ = true; }
    void        stripAlpha()   { stripAlpha_  = true; }     ///< t摜̏ꍇł,𖳎.
    void        toTrueColor()  { toTrueColor_ = true; bpp_ = haveAlpha_ ? 32 : 24; }
    void        setWidthAlign(unsigned align);

    // ֌W̋ւɂȂĂ܂.
    void        toClutBpp8()   { toClutBpp8_  = true; bpp_ = 8; }

    unsigned    clutSize()   const { return clutSize_; }
    unsigned    getClut(unsigned* clut, unsigned clutSize=0);

    unsigned    imageByte()  const;                         ///< KvȁAWJoCgԂ.
    bool        read(void* img);

    void*       read(unsigned widAlgn=1, unsigned dir=0);

private:
    static void raw_read_data(struct png_struct_def* png_ptr, unsigned char* data, size_t length);

private:
    const unsigned char*    binData_;
    struct png_struct_def*  png_ptr_;
    struct png_info_def*    info_ptr_;
    unsigned                binDataSize_;
    unsigned                cur_;

    unsigned                width_;
    unsigned                height_;
    int                     orgBpp_;
    int                     bpp_;
    unsigned                clutSize_;
    bool                    haveAlpha_;

    int                     color_type_;
    int                     interlace_type_;
    unsigned                sig_read_;

    unsigned                align_;
    bool                    revY_;
    bool                    bigEndian_;
    bool                    toTrueColor_;
    bool                    toClutBpp8_;
    bool                    stripAlpha_;

    bool                    closeRq_;
};

#endif  // PNGDECODER_H
