/**
 *  @file JpgEncoder.hpp
 *  @brief  jpg摜f[^WJ.
 *  @author Masashi KITAMURA
 *  @note
 *      - Independent JPEG Grouplibjpeg.libpĂ܂B
 *
 *      - g
 *          - setData(binData,size) Ń[jpgf[^ݒ肵A
 *            ̌ read()malloc24rbgF摜𓾂.
 *          - 邢setData(), TCYwidthByte()*height() ȏ̃
 *            Ăьŗpӂread(pix, ...)g.
 */
#ifndef JPGENCODER_HPP
#define JPGENCODER_HPP

#include <assert.h>

/// 24rbgF摜jpgf[^Ɉk. (libjpeg.lib̃bp[)
/// 1sNŹAR,G,Bɕ񂾃mgGfBAlƂĂBGR
class JpgEncoder {
public:
    JpgEncoder() {;}
    ~JpgEncoder() {;}

    JpgEncoder(unsigned char* dst, unsigned dstSz, const void* src, unsigned wid, unsigned hei, unsigned quality=90, unsigned widByt=0, unsigned dir=0, unsigned* pSz=0) {
        unsigned sz = write(dst,dstSz, src, wid, hei, quality, widByt, dir);
        if (pSz)
            *pSz = sz;
    }

    /// ŊmۂĂ郁J. 덇킹p̃_~[.
    void    release() {;}

    /// pix 24rbgF摜WJ. TCY0ƃftHĝ܂. dir0ォ1Ȃ獶.
    static unsigned     write(unsigned char* dst, unsigned dstSz, const void* src, unsigned wid, unsigned hei, unsigned quality=90, unsigned widByt=0, unsigned dir=0, unsigned mono=0);

    /// malloc jpgf[^ĕԂ.
    static unsigned char*  write(const void* src, unsigned wid, unsigned hei, unsigned quality=90, unsigned widByt=0, unsigned dir=0, unsigned*pSz=0);

    /// writeŃ|C^󂯎ꍇ̑΂ƂȂ郁J.
    static void     deallocate(void* p);

    /// oCgɕϊ.
    static unsigned wid2byt(unsigned wid, unsigned algn=1) {
        assert( algn == 1 || algn == 2 || algn == 4 || algn == 8 || algn == 16 );
        return (wid*3 + algn-1) & ~(algn-1);
    }
};

#endif  // JPGENCODER_H
