/**
 *  @file JpgDecoder.hpp
 *  @brief  jpg摜f[^WJ.
 *  @author Masashi KITAMURA
 *  @note
 *      - Independent JPEG Grouplibjpeg.libpĂ܂B
 *
 *      - g
 *          - setData(binData,size) Ń[jpgf[^ݒ肵A
 *            ̌ read()malloc24rbgF摜𓾂.
 *          - 邢setData(), TCYwidthByte()*height() ȏ̃
 *            Ăьŗpӂread(pix, ...)g.
 */
#ifndef JPGDECODER_HPP
#define JPGDECODER_HPP

#include <cstdlib>      // callocwb_Ŏgp邽.
#include <cassert>
#include <string.h>
#include <memory.h>



/// jpg摜f[^WJ. (libjpeg.lib̃bp[)
class JpgDecoder {
public:
    JpgDecoder();
    ~JpgDecoder();
    JpgDecoder(const void* binData, unsigned binDataSize, bool thumbnail=false);

    /// ŊmۂĂ郁J.
    void        release();

    static bool isSupported(const void* data) {
        const unsigned char* b = (unsigned char*)data;
      #if 1
        return (b[0] == 0xFF && b[1] == 0xD8);
      #else
        if (b[0] != 0xFF || b[1] != 0xD8)
            return false;
        if (b[2] == 0xFF && b[3] == 0xE1 && memcmp(b+6,"JFIF", 4) == 0)
            return true;
        return (b[2] == 0xFF && b[3] == 0xE1 && memcmp(b+6,"Exif", 4) == 0);
      #endif
    }

    /// jpgf[^ݒ. |C^ێ邾Ȃ̂read()IObinDataj󂵂Ȃ.
    bool        setData(const void* binData, unsigned binDataSize, bool thumbnail=false);

    unsigned    bpp()        const { return bpp_; }         	///< rbg/sNZ. 24̂.
    unsigned    width()      const;                         	///< .
    unsigned    height()     const;                         	///< c.
    unsigned    widthByte()  const { return width()*bpp_>>3; }	///< oCg.
    unsigned    widthByte(unsigned algn) const;             	///< algnoCgɃACgς̉.

    unsigned    imageByte()  const { return widthByte() * height(); }

    /// pix 24rbgF摜WJ. TCY0ƃftHĝ܂. dir0ォ1Ȃ獶.
    bool        read(void* pix, unsigned widByt=0, unsigned hei=0, unsigned dir=0);

    /// malloc ɉ摜ĕԂ.
    void*       read(unsigned widAlgn=1, unsigned dir=0);

	unsigned	originalWidth() const { return originalWidth_; }	// thumbnailw莞̌TCY
	unsigned	originalHeight() const { return originalHeight_; }	// thumbnailw莞̌TCY

	unsigned const*	clut() const { return gray_clut_; }

private:
    struct jpeg_decompress_struct*  info_;
    struct jpeg_error_mgr*          jerr_;
    void*                           binData_;
    unsigned                        binDataSize_;
    bool                            closeRq_;
    bool                            thumbnail_;
	unsigned						originalWidth_;
	unsigned						originalHeight_;
	int								bpp_;
	unsigned						gray_clut_[256];
};



/** algnoCgɃACgς݂̉oCgԂ.
 */
inline unsigned     JpgDecoder::widthByte(unsigned algn) const {
    assert( algn == 1 || algn == 2 || algn == 4 || algn == 8 || algn == 16 );
    return (widthByte() + algn-1) & ~(algn-1);
}



#endif  // JPGDECODER_H
